@echo off
title RageOT Launcher
color 0A

echo.
echo  ========================================
echo       RageOT Launcher v1.0
echo       Protocolo 15.11
echo  ========================================
echo.

:: Config
set "SERVER_URL=https://rageot.com.br"
set "VERSION_URL=%SERVER_URL%/downloads/version.json"
set "LOCAL_VERSION_FILE=%~dp0version.txt"
set "CLIENT_EXE=%~dp0bin\client.exe"

:: Check if client exists
if not exist "%CLIENT_EXE%" (
    echo  [ERRO] client.exe nao encontrado em bin\
    echo  Extraia o client completo antes de usar o launcher.
    echo.
    pause
    exit /b 1
)

:: Read local version
set "LOCAL_VERSION=0.0.0"
if exist "%LOCAL_VERSION_FILE%" (
    set /p LOCAL_VERSION=<"%LOCAL_VERSION_FILE%"
)

echo  Versao local: %LOCAL_VERSION%
echo  Verificando atualizacoes...
echo.

:: Check for updates using PowerShell
powershell -NoProfile -ExecutionPolicy Bypass -Command ^
    "$ErrorActionPreference = 'SilentlyContinue'; " ^
    "try { " ^
    "  [Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12; " ^
    "  $response = Invoke-WebRequest -Uri '%VERSION_URL%' -UseBasicParsing -TimeoutSec 10; " ^
    "  $json = $response.Content | ConvertFrom-Json; " ^
    "  $remoteVersion = $json.version; " ^
    "  $localVersion = '%LOCAL_VERSION%'; " ^
    "  if ($remoteVersion -ne $localVersion) { " ^
    "    Write-Host '  Nova versao disponivel: ' $remoteVersion -ForegroundColor Yellow; " ^
    "    Write-Host ''; " ^
    "    Write-Host '  Acesse %SERVER_URL%/?p=download para baixar.' -ForegroundColor Cyan; " ^
    "    Write-Host '  Changelog: ' $json.changelog -ForegroundColor Gray; " ^
    "    Write-Host ''; " ^
    "    $choice = Read-Host '  Deseja continuar com a versao atual? (S/N)'; " ^
    "    if ($choice -ne 'S' -and $choice -ne 's') { " ^
    "      Start-Process '%SERVER_URL%/?p=download'; " ^
    "      exit 1; " ^
    "    } " ^
    "  } else { " ^
    "    Write-Host '  Client atualizado!' -ForegroundColor Green; " ^
    "  } " ^
    "} catch { " ^
    "  Write-Host '  Nao foi possivel verificar atualizacoes.' -ForegroundColor DarkYellow; " ^
    "  Write-Host '  Continuando com versao local...' -ForegroundColor DarkYellow; " ^
    "}"

if %ERRORLEVEL% EQU 1 (
    exit /b 0
)

echo.
echo  Iniciando RageOT...
echo.

:: Launch client
start "" "%CLIENT_EXE%"
exit /b 0
